#include <xc.h>

#include <system.h>
#include <usb_config.h>

#include <usb.h>
#include <usb_device_hid.h>
#include <hid.h>
#include <led_usb_status.h>

#if defined (USE_INTERNAL_OSC)	    // Define this in system.h if using the HFINTOSC for USB operation
    // CONFIG1
    #pragma config FOSC = INTOSC    // Oscillator Selection Bits (INTOSC oscillator: I/O function on CLKIN pin)
    #pragma config WDTE = OFF       // Watchdog Timer Enable (WDT disabled)
    #pragma config PWRTE = OFF      // Power-up Timer Enable (PWRT disabled)
    #pragma config MCLRE = ON      // MCLR Pin Function Select (MCLR/VPP pin function is digital input)
    #pragma config CP = OFF         // Flash Program Memory Code Protection (Program memory code protection is disabled)
    #pragma config BOREN = ON       // Brown-out Reset Enable (Brown-out Reset enabled)
    #pragma config CLKOUTEN = OFF   // Clock Out Enable (CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin)
    #pragma config IESO = OFF       // Internal/External Switchover Mode (Internal/External Switchover Mode is disabled)
    #pragma config FCMEN = OFF      // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is disabled)

    // CONFIG2
    #pragma config WRT = OFF        // Flash Memory Self-Write Protection (Write protection off)
    #pragma config CPUDIV = NOCLKDIV// CPU System Clock Selection Bit (NO CPU system divide)
    #pragma config USBLSCLK = 48MHz // USB Low SPeed Clock Selection bit (System clock expects 48 MHz, FS/LS USB CLKENs divide-by is set to 8.)
    #pragma config PLLMULT = 3x     // PLL Multipler Selection Bit (3x Output Frequency Selected)
    #pragma config PLLEN = ENABLED  // PLL Enable Bit (3x or 4x PLL Enabled)
    #pragma config STVREN = ON      // Stack Overflow/Underflow Reset Enable (Stack Overflow or Underflow will cause a Reset)
    #pragma config BORV = LO        // Brown-out Reset Voltage Selection (Brown-out Reset Voltage (Vbor), low trip point selected.)
    #pragma config LPBOR = OFF      // Low-Power Brown Out Reset (Low-Power BOR is disabled)
    #pragma config LVP = OFF        // Low-Voltage Programming Enable (High-voltage on MCLR/VPP must be used for programming)
#else
    // CONFIG1
    #pragma config FOSC = HS        // Oscillator Selection Bits (HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins)
    #pragma config WDTE = OFF       // Watchdog Timer Enable (WDT disabled)
    #pragma config PWRTE = OFF      // Power-up Timer Enable (PWRT disabled)
    #pragma config MCLRE = OFF      // MCLR Pin Function Select (MCLR/VPP pin function is digital input)
    #pragma config CP = OFF         // Flash Program Memory Code Protection (Program memory code protection is disabled)
    #pragma config BOREN = ON       // Brown-out Reset Enable (Brown-out Reset enabled)
    #pragma config CLKOUTEN = OFF   // Clock Out Enable (CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin)
    #pragma config IESO = OFF       // Internal/External Switchover Mode (Internal/External Switchover Mode is disabled)
    #pragma config FCMEN = OFF      // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is disabled)

    // CONFIG2
    #pragma config WRT = OFF        // Flash Memory Self-Write Protection (Write protection off)
    #pragma config CPUDIV = NOCLKDIV// CPU System Clock Selection Bit (NO CPU system divide)
    #pragma config USBLSCLK = 48MHz // USB Low SPeed Clock Selection bit (System clock expects 48 MHz, FS/LS USB CLKENs divide-by is set to 8.)
    #pragma config PLLMULT = 4x     // PLL Multipler Selection Bit (4x Output Frequency Selected)
    #pragma config PLLEN = ENABLED  // PLL Enable Bit (3x or 4x PLL Enabled)
    #pragma config STVREN = ON      // Stack Overflow/Underflow Reset Enable (Stack Overflow or Underflow will cause a Reset)
    #pragma config BORV = LO        // Brown-out Reset Voltage Selection (Brown-out Reset Voltage (Vbor), low trip point selected.)
    #pragma config LPBOR = OFF      // Low-Power Brown Out Reset (Low-Power BOR is disabled)
    #pragma config LVP = OFF        // Low-Voltage Programming Enable (High-voltage on MCLR/VPP must be used for programming)
#endif

uint8_t TX_counter = 0;
uint8_t RX_counter = 0;

volatile bool interrupt_pending = false;

void SYSTEM_Initialize( void )
{
    #if defined(USE_INTERNAL_OSC)
        OSCCON = 0xFC;  
        ACTCON = 0x90;  
    #endif


    LATCbits.LATC2 = 0;
    LATCbits.LATC3 = 0;
    LATCbits.LATC7 = 0;
    LATBbits.LATB6 = 0;
    
    TRISCbits.TRISC2 = 0; //TX_LED
    TRISCbits.TRISC3 = 0; //RX_LED
    TRISCbits.TRISC7 = 0; //SDO
    TRISBbits.TRISB6 = 0; //SCK
      
    ADCON0 = 0x29;
    ADCON1 = 0xE0;
    ADCON2 = 0x00;
    
    SPIBAUD(4000000);
    SSP1CON1 = 0x2A;
    SSP1STAT = 0x40;
    
    TMR1L = 0xE0;
    TMR1H = 0x2E;
    PIE1bits.TMR1IE = 1;
    T1CONbits.TMR1ON = 1;
}

void interrupt ISR(void)
{
    if(PIR2bits.USBIF)
    {
        #if defined(USB_INTERRUPT)
            USBDeviceTasks();
        #endif
    }   
    
    if(PIR1bits.TMR1IF)
    {
        TMR1L = 0xE0;
        TMR1H = 0x2E;
        PIR1bits.TMR1IF = 0;
        if(TX_counter == 6)
        {
            TX_counter = 0;
            HIDTxLED = 1;
        }
        
        if(RX_counter == 6)
        {
            RX_counter = 0;
            HIDRxLED = 1;
        }
        
        if(TX_counter != 0)
            TX_counter++;
        if(RX_counter != 0)
            RX_counter++;
        
    }
}

bool USER_USB_CALLBACK_EVENT_HANDLER(USB_EVENT event, void *pdata, uint16_t size)
{
    switch((int)event)
    {
        case EVENT_TRANSFER:
            LEDUpdateUSBStatus(pdata);
            interrupt_pending = true;
            break;

        case EVENT_SOF:
            break;

        case EVENT_SUSPEND:
            break;

        case EVENT_RESUME:
            break;

        case EVENT_CONFIGURED:
            HIDInitialize();
            break;

        case EVENT_SET_DESCRIPTOR:
            break;

        case EVENT_EP0_REQUEST:
            USBCheckHIDRequest();
            break;

        case EVENT_BUS_ERROR:
            break;

        case EVENT_TRANSFER_TERMINATED:
            break;

        default:
            break;
    }
    return true;
}